#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Frozen SwampMod01.fsh   by   AieKick 
//https://www.shadertoy.com/view/4lScRy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
//uniform sampler2D iChannel2;
//uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Stephane Cuillerdier - Aiekick/2017 (twitter:@aiekick)
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Tuned via XShade (http://www.funparadigm.com/xshade/)
// link : https://www.shadertoy.com/view/lt2yWw

vec2 path(float t)
{
	return vec2(cos(t * .1), sin(t * .1)) * 3.;
}

float fullAtan(vec2 p)
{
    return step(0.0,-p.x)*3.1415926535 + sign(p.x) * atan(p.x, sign(p.x) * p.y);
}

float fractus(vec2 p, vec2 v)
{
	vec2 z = p;
    vec2 c = v;
	float k = 1., h = 1.0;    
    for (float i=0.;i<5.;i++)
    {
        h *= 4.*k;
		k = dot(z,z);
        if(k > 4.) break;
		z = vec2(z.x * z.x - z.y * z.y, 2. * z.x * z.y) + c;
    }
	return sqrt(k/h)*log(k);   
}

vec4 dfFractus(vec3 p)
{
	float st = 5.;
    
    float id = floor(p.z / st);
    
    float a = fullAtan(p.xy);
    
    vec2 c;
    c.x = mix(0.2, -0.5, cos(a * 4. + id));
    c.y = mix(0.5, 0.0, sin(a * 3. + id));
    
    p.z = mod(p.z, st) - st * .5;
    
    float path = length(p.xy) - 3.;
    
    vec2 rev = vec2(path, p.z);
    float aa = a + id;
    rev *= mat2(cos(aa),-sin(aa),sin(aa),cos(aa));
	
	return vec4(fractus(rev, c) - 0.05, rev, 20.0);;
}

vec2 getTunnelPath(float t, vec2 s)
{
	vec2 p = vec2(cos(t*0.2), sin(t*-0.2)) * s * 2.;
	t *= 0.1;
	p *= mat2(cos(t),-sin(t),sin(t), cos(t));
	return p;
}

float getTutu(vec3 p)
{
    //p.x = mod(p.x+2.5, 5.)-2.5;
	return length(p.xy)-0.5; // thick
}

//--------------------------------------------------------------------------
// Grab all sky information for a given ray from camera
// from Dave Hoskins // https://www.shadertoy.com/view/Xsf3zX
vec3 GetSky(in vec3 rd, in vec3 sunDir, in vec3 sunCol)
{
	float sunAmount = max( dot( rd, sunDir), 0.0 );
	float v = pow(1.0-max(rd.y,0.0),6.);
	vec3  sky = mix(vec3(.1, .2, .3), vec3(0.6,0.8,1.), v);
	sky = sky + sunCol * sunAmount * sunAmount * .25;
	sky = sky + sunCol * min(pow(sunAmount, 800.0)*1.5, .3);
	return clamp(sky, 0.0, 1.0);
}

vec4 minObj(vec4 a, vec4 b)
{
	if (a.x < b.x) 
        return a;
    return b;
}

vec4 df(vec3 p)
{
    // texture here get a error on some gpu, get a gradient in loop error.
    // textureLod is ok
    vec3 tex = textureLod(iChannel0, p.xz * 0.5, 0.).rgb;
    float disp = dot(tex, vec3(0.01));
    
    vec2 q = p.xy + path(p.z);
    
    float plane = q.y + cos(q.x * .1) - 0.8 + disp;

    p.xy -= getTunnelPath(p.z,vec2(0.2,0.2));
    float tutu = getTutu(p * vec3(0.2,0.5,1));
    
    vec4 ftus = dfFractus(p);
    
    vec4 ground = vec4(max(plane,-min(ftus.x-0.1,tutu)),0,0,10.);
    
    return minObj(ground, ftus);
}

vec3 nor( vec3 pos, float prec )
{
	vec3 eps = vec3( prec, 0., 0. );
	vec3 nor = vec3(
	    df(pos+eps.xyy).x - df(pos-eps.xyy).x,
	    df(pos+eps.yxy).x - df(pos-eps.yxy).x,
	    df(pos+eps.yyx).x - df(pos-eps.yyx).x );
	return normalize(nor);
}

// return color from temperature 
//http://www.physics.sfasu.edu/astro/color/blackbody.html
//http://www.vendian.org/mncharity/dir3/blackbody/
//http://www.vendian.org/mncharity/dir3/blackbody/UnstableURLs/bbr_color.html
vec3 blackbody(float Temp)
{
	vec3 col = vec3(255.);
    col.x = 56100000. * pow(Temp,(-3. / 2.)) + 148.;
   	col.y = 100.04 * log(Temp) - 623.6;
   	if (Temp > 6500.) col.y = 35200000. * pow(Temp,(-3. / 2.)) + 184.;
   	col.z = 194.18 * log(Temp) - 1448.6;
   	col = clamp(col, 0., 255.)/255.;
    if (Temp < 1000.) col *= Temp/1000.;
   	return col;
}

// get density of the df at surfPoint
// ratio between constant step and df value
float SubDensity(vec3 surfPoint, float ms) 
{
	vec3 n = nor(surfPoint,0.0001); 
	return df(surfPoint - n * ms).x/ms;
}

// from shane shaders
// Tri-Planar blending function. Based on an old Nvidia writeup:
// GPU Gems 3 - Ryan Geiss: http://http.developer.nvidia.com/GPUGems3/gpugems3_ch01.html
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n )
{
    n = max((abs(n) - .2)*7., .001);
    n /= (n.x + n.y + n.z );  
    p = (texture2D(tex, p.yz)*n.x + texture2D(tex, p.zx)*n.y + texture2D(tex, p.xy)*n.z).xyz;
    return p*p;
}

// from shane shaders
// Texture bump mapping. Four tri-planar lookups, or 12 texture lookups in total. I tried to 
// make it as concise as possible. Whether that translates to speed, or not, I couldn't say.
vec3 doBumpMap( sampler2D tx, in vec3 p, in vec3 n, float bf)
{
    const vec2 e = vec2(0.001, 0);
    mat3 m = mat3( tex3D(tx, p - e.xyy, n), tex3D(tx, p - e.yxy, n), tex3D(tx, p - e.yyx, n));
    vec3 g = vec3(0.299, 0.587, 0.114)*m; // Converting to greyscale.
    g = (g - dot(tex3D(tx,  p , n), vec3(0.299, 0.587, 0.114)) )/e.x; g -= n*dot(n, g);
    return normalize( n + g*bf ); // Bumped normal. "bf" - bump factor.
}

// shading func
vec3 shadeGround(vec3 ro, vec3 rd, float d, vec3 ld, float li)
{
	vec3 p = ro + rd * d;		
	vec3 n = nor(p, 0.1);		
    
    n = doBumpMap(iChannel0, p*.5, n, 0.005);
	
	vec3 refl = reflect(rd,n);	
	
	float amb = 0.6; 											
	float diff = clamp( dot( n, ld ), 0.0, 1.0 ); 				
	float fre = pow( clamp( 1. + dot(n,rd),0.0,1.0), 4. ); 		
	float spe = pow(clamp( dot( refl, ld ), 0.0, 1.0 ),16.); 	
	float sss = 1. - SubDensity(p, 1.); 						
	
    return vec3(
        (diff + fre + spe * 2.) * amb * li,
        (diff + fre + sss) * amb * li + spe * 1.2,
        (diff + fre - spe * 0.2 + sss * .8) * amb * li
    );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // vars
	vec2 g = fragCoord;
	vec2 si = iResolution.xy;
	vec2 mo = iMouse.xy;
	float time = iTime * 5.;
	
	vec3 col = vec3(0);
            
	vec3 ro = vec3(0,0,time);
	ro.xy += getTunnelPath(ro.z,vec2(0.2,0.2));
    
	vec3 lp = ro + vec3(0,2,5);
	
    vec3 cv = ro + vec3(0,0,1);
    cv.xy += getTunnelPath(cv.z,vec2(0.2,0.2));
    
	vec3 cu = normalize(vec3(0,1,0));
  	vec3 z = normalize(cv-ro);
    vec3 x = normalize(cross(cu,z));
  	vec3 y = cross(z,x);
    
  	vec2 uv = (g+g-si)/si.y;
   	vec3 rd = normalize(z + uv.x*x + uv.y*y);

	float md = 100.;

    float accum = 0.0;
    
	float s = 1., d = 0.;
	for (float i=0.; i<250.; i++)
	{
		if (d*d/s > 1e6 || d > md) break;
		s = df(ro+rd*d).x;
		d += s * .2;
        accum += 0.002;
	}
	
    vec3 ld = normalize(lp - ro-rd*d);
	
    vec3 sky = GetSky(rd, ld, vec3(1.5));
    
    if (d < md)
    {
        vec3 p = ro+rd*d; // surf point
        vec3 mat = vec3(0.6,0.8,1.);
        vec4 dfMat = df(p);
        vec3 n = nor(p, 0.1);
       	float incl = acos(dot(n, vec3(0,1,0)));
        vec3 refl = reflect(rd,n);	

        if (dfMat.w > 19.5) // fractus
        {
            vec3 tex = texture2D(iChannel1, dfMat.yz).rgb;
			vec3 tex1 = texture2D(iChannel1, dfMat.yz+0.1).rgb;

            n += (tex1-tex);
            
            float amb = 0.6; 											
            float diff = clamp( dot(n, ld), 0.0, 1.0 ); 				
            float fre = pow( clamp( 1. + dot(n, rd),0.0,1.0), 4. ); 		
            float spe = pow(clamp( dot(refl, ld), 0.0, 1.0 ),16.); 	

            col = (tex * diff * .8 + fre * .1 + mat * spe * .8 );
       
            // snow
            vec3 texSnow = texture2D(iChannel0, p.xz*.2).rgb;
            texSnow = smoothstep(texSnow+0.5, texSnow, vec3(0.7));
            col = mix(col, vec3(0.9,0.9,1.0), 0.2+smoothstep(texSnow.r, 0.0, incl)*.8);
        }
        else if (dfMat.w > 9.5) // ground
        {
            // sub surface
            for (float i = 0.; i < 1.; i+=0.1)
            {
                float y = shadeGround(p, rd, i, ld, i).y;
                mat = blackbody(1000. + y * 900.).bgr * 0.8;
                col = min(mix(col, y * mat, i), vec3(2.));
            }

            // surface
            vec2 xz = shadeGround(ro, rd, d, ld, 1.).xz;
            mat = blackbody(2000. + xz.x * 3. * 900.).bgr * 0.2;
            col = mix(col, xz.x * 3. * mat, 0.7);

            // snow
            vec3 texSnow = texture2D(iChannel0, p.xz*.2).rgb;
            texSnow = smoothstep(texSnow+0.5, texSnow, vec3(.7));
            col = mix(col, vec3(0.9,0.9,1.0) * xz.y, smoothstep(texSnow.r, 0.0, incl));
        }
    }
    
	col = mix(col, sky, 1.0-exp(-0.01*d*d));

    col = sqrt(col * col * .8);

    col += accum * (1.0-exp(-0.01*d*d));
    
	vec2 v = g/si;
    col *= 0.5 + 0.5*pow( 16.0*v.x*v.y*(1.0-v.x)*(1.0-v.y), 0.25 ); // iq vignette
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

